<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$db = Database::getInstance();

$date = $_GET['date'] ?? date('Y-m-d');

$attendance = $db->fetchAll(
    "SELECT a.*, u.name, u.employee_id 
     FROM attendance a 
     JOIN users u ON a.user_id = u.id 
     WHERE a.date = ? 
     ORDER BY a.check_in DESC",
    [$date]
);

$summary = $db->fetchOne(
    "SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN status = 'present' THEN 1 ELSE 0 END) as present,
        SUM(CASE WHEN status = 'absent' THEN 1 ELSE 0 END) as absent,
        SUM(CASE WHEN status = 'leave' THEN 1 ELSE 0 END) as on_leave
     FROM attendance WHERE date = ?",
    [$date]
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سجل الحضور - IT Task Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .sidebar { background: #2c3e50; min-height: 100vh; }
        .sidebar a { color: #ecf0f1; padding: 15px 20px; display: block; text-decoration: none; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-2 sidebar p-0">
            <div class="p-3 text-white text-center">
                <h5><i class="bi bi-gear-fill"></i> لوحة التحكم</h5>
            </div>
            <hr class="bg-light">
            <a href="index.php"><i class="bi bi-speedometer2"></i> الرئيسية</a>
            <a href="users.php"><i class="bi bi-people"></i> المستخدمين</a>
            <a href="tasks.php"><i class="bi bi-list-task"></i> المهام</a>
            <a href="attendance.php" class="active"><i class="bi bi-clock-history"></i> الحضور</a>
            <a href="notifications.php"><i class="bi bi-bell"></i> الإشعارات</a>
            <hr class="bg-light">
            <a href="logout.php"><i class="bi bi-box-arrow-right"></i> خروج</a>
        </div>

        <div class="col-md-10 p-4">
            <h4 class="mb-4">سجل الحضور</h4>

            <!-- Date Filter -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" class="row g-3 align-items-center">
                        <div class="col-auto">
                            <label class="form-label">التاريخ:</label>
                        </div>
                        <div class="col-auto">
                            <input type="date" name="date" class="form-control" value="<?= $date ?>">
                        </div>
                        <div class="col-auto">
                            <button type="submit" class="btn btn-primary">عرض</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Summary -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body text-center">
                            <h3><?= $summary['total'] ?? 0 ?></h3>
                            <p class="mb-0">إجمالي السجلات</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body text-center">
                            <h3><?= $summary['present'] ?? 0 ?></h3>
                            <p class="mb-0">حاضرين</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-danger text-white">
                        <div class="card-body text-center">
                            <h3><?= $summary['absent'] ?? 0 ?></h3>
                            <p class="mb-0">غائبين</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body text-center">
                            <h3><?= $summary['on_leave'] ?? 0 ?></h3>
                            <p class="mb-0">إجازة</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>رقم الموظف</th>
                                <th>الاسم</th>
                                <th>وقت الدخول</th>
                                <th>وقت الخروج</th>
                                <th>ساعات العمل</th>
                                <th>الحالة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($attendance)): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4">لا توجد سجلات لهذا التاريخ</td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($attendance as $a): ?>
                            <tr>
                                <td><?= htmlspecialchars($a['employee_id']) ?></td>
                                <td><?= htmlspecialchars($a['name']) ?></td>
                                <td><?= $a['check_in'] ? date('H:i', strtotime($a['check_in'])) : '-' ?></td>
                                <td><?= $a['check_out'] ? date('H:i', strtotime($a['check_out'])) : '-' ?></td>
                                <td>
                                    <?php
                                    if ($a['total_work_minutes']) {
                                        $hours = floor($a['total_work_minutes'] / 60);
                                        $mins = $a['total_work_minutes'] % 60;
                                        echo "{$hours}:{$mins}";
                                    } else {
                                        echo '-';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $statusClass = match($a['status']) {
                                        'present' => 'bg-success',
                                        'absent' => 'bg-danger',
                                        'leave' => 'bg-warning',
                                        'half_day' => 'bg-info',
                                        default => 'bg-secondary'
                                    };
                                    $statusText = match($a['status']) {
                                        'present' => 'حاضر',
                                        'absent' => 'غائب',
                                        'leave' => 'إجازة',
                                        'half_day' => 'نصف يوم',
                                        default => $a['status']
                                    };
                                    ?>
                                    <span class="badge <?= $statusClass ?>"><?= $statusText ?></span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
