<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';

$db = Database::getInstance();

// Check if logged in
if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$user = $_SESSION['admin_user'];

// Get statistics
$stats = [
    'total_users' => $db->fetchOne("SELECT COUNT(*) as count FROM users")['count'],
    'active_users' => $db->fetchOne("SELECT COUNT(*) as count FROM users WHERE status = 'active'")['count'],
    'total_tasks' => $db->fetchOne("SELECT COUNT(*) as count FROM tasks")['count'],
    'pending_tasks' => $db->fetchOne("SELECT COUNT(*) as count FROM tasks WHERE status IN ('new', 'started')")['count'],
    'completed_tasks' => $db->fetchOne("SELECT COUNT(*) as count FROM tasks WHERE status = 'completed'")['count'],
    'today_attendance' => $db->fetchOne("SELECT COUNT(*) as count FROM attendance WHERE date = CURDATE()")['count'],
];

// Get recent tasks
$recentTasks = $db->fetchAll("SELECT t.*, u.name as creator_name FROM tasks t LEFT JOIN users u ON t.created_by = u.id ORDER BY t.created_at DESC LIMIT 10");

// Get all users for notifications
$users = $db->fetchAll("SELECT id, name, email, role FROM users WHERE status = 'active' ORDER BY name");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - IT Task Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .sidebar { background: #2c3e50; min-height: 100vh; }
        .sidebar a { color: #ecf0f1; padding: 15px 20px; display: block; text-decoration: none; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; }
        .stat-card { border-radius: 10px; border: none; }
        .stat-card .icon { font-size: 2.5rem; opacity: 0.8; }
        .stat-card.primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .stat-card.success { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); color: white; }
        .stat-card.warning { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; }
        .stat-card.info { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-2 sidebar p-0">
            <div class="p-3 text-white text-center">
                <h5><i class="bi bi-gear-fill"></i> لوحة التحكم</h5>
                <small><?= htmlspecialchars($user['name']) ?></small>
            </div>
            <hr class="bg-light">
            <a href="index.php" class="active"><i class="bi bi-speedometer2"></i> الرئيسية</a>
            <a href="users.php"><i class="bi bi-people"></i> المستخدمين</a>
            <a href="tasks.php"><i class="bi bi-list-task"></i> المهام</a>
            <a href="attendance.php"><i class="bi bi-clock-history"></i> الحضور</a>
            <a href="notifications.php"><i class="bi bi-bell"></i> الإشعارات</a>
            <hr class="bg-light">
            <a href="logout.php"><i class="bi bi-box-arrow-right"></i> خروج</a>
        </div>

        <!-- Main Content -->
        <div class="col-md-10 p-4">
            <h4 class="mb-4">مرحباً، <?= htmlspecialchars($user['name']) ?></h4>
            
            <!-- Statistics -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card stat-card primary">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h3><?= $stats['total_users'] ?></h3>
                                <p class="mb-0">المستخدمين</p>
                            </div>
                            <i class="bi bi-people icon"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stat-card success">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h3><?= $stats['total_tasks'] ?></h3>
                                <p class="mb-0">المهام</p>
                            </div>
                            <i class="bi bi-list-task icon"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stat-card warning">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h3><?= $stats['pending_tasks'] ?></h3>
                                <p class="mb-0">مهام قيد التنفيذ</p>
                            </div>
                            <i class="bi bi-hourglass-split icon"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card stat-card info">
                        <div class="card-body d-flex justify-content-between align-items-center">
                            <div>
                                <h3><?= $stats['today_attendance'] ?></h3>
                                <p class="mb-0">حضور اليوم</p>
                            </div>
                            <i class="bi bi-person-check icon"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Send Notification -->
                <div class="col-md-5">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <i class="bi bi-bell"></i> إرسال إشعار
                        </div>
                        <div class="card-body">
                            <form action="send_notification.php" method="POST">
                                <div class="mb-3">
                                    <label class="form-label">إرسال إلى</label>
                                    <select name="recipient" class="form-select" required>
                                        <option value="all">الجميع</option>
                                        <option value="staff">الموظفين فقط</option>
                                        <option value="managers">المدراء فقط</option>
                                        <?php foreach ($users as $u): ?>
                                        <option value="user_<?= $u['id'] ?>"><?= htmlspecialchars($u['name']) ?> (<?= $u['role'] ?>)</option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">عنوان الإشعار</label>
                                    <input type="text" name="title" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">نص الإشعار</label>
                                    <textarea name="body" class="form-control" rows="3" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-send"></i> إرسال
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Recent Tasks -->
                <div class="col-md-7">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <i class="bi bi-list-task"></i> آخر المهام
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>رقم المهمة</th>
                                        <th>العنوان</th>
                                        <th>الحالة</th>
                                        <th>التاريخ</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentTasks as $task): ?>
                                    <tr>
                                        <td><code><?= $task['task_id'] ?></code></td>
                                        <td><?= htmlspecialchars(mb_substr($task['title'], 0, 30)) ?></td>
                                        <td>
                                            <?php
                                            $statusClass = match($task['status']) {
                                                'new' => 'bg-secondary',
                                                'started' => 'bg-primary',
                                                'on_hold' => 'bg-warning',
                                                'completed' => 'bg-success',
                                                'cancelled' => 'bg-danger',
                                                default => 'bg-secondary'
                                            };
                                            $statusText = match($task['status']) {
                                                'new' => 'جديد',
                                                'started' => 'قيد التنفيذ',
                                                'on_hold' => 'معلق',
                                                'completed' => 'مكتمل',
                                                'cancelled' => 'ملغي',
                                                default => $task['status']
                                            };
                                            ?>
                                            <span class="badge <?= $statusClass ?>"><?= $statusText ?></span>
                                        </td>
                                        <td><small><?= date('Y-m-d', strtotime($task['created_at'])) ?></small></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
