<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';
require_once '../api/services/NotificationService.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$db = Database::getInstance();
$user = $_SESSION['admin_user'];
$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

// Handle send notification
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $recipient = $_POST['recipient'] ?? '';
    $title = $_POST['title'] ?? '';
    $body = $_POST['body'] ?? '';

    if (empty($title) || empty($body)) {
        $_SESSION['error'] = 'يرجى ملء جميع الحقول';
    } else {
        $sentCount = 0;
        if ($recipient === 'all') {
            $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active'");
            foreach ($users as $u) {
                NotificationService::send($u['id'], $title, $body, 'admin_message');
                $sentCount++;
            }
        } elseif ($recipient === 'staff') {
            $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active' AND role = 'staff'");
            foreach ($users as $u) {
                NotificationService::send($u['id'], $title, $body, 'admin_message');
                $sentCount++;
            }
        } elseif ($recipient === 'managers') {
            $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active' AND role IN ('admin', 'manager')");
            foreach ($users as $u) {
                NotificationService::send($u['id'], $title, $body, 'admin_message');
                $sentCount++;
            }
        } elseif (strpos($recipient, 'user_') === 0) {
            $userId = (int) str_replace('user_', '', $recipient);
            NotificationService::send($userId, $title, $body, 'admin_message');
            $sentCount = 1;
        }
        $_SESSION['success'] = "تم إرسال الإشعار إلى {$sentCount} مستخدم";
    }
    header('Location: notifications.php');
    exit;
}

$users = $db->fetchAll("SELECT id, name, email, role FROM users WHERE status = 'active' ORDER BY name");
$recentNotifications = $db->fetchAll(
    "SELECT n.*, u.name as user_name FROM notifications n 
     JOIN users u ON n.user_id = u.id 
     ORDER BY n.created_at DESC LIMIT 50"
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>الإشعارات - IT Task Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .sidebar { background: #2c3e50; min-height: 100vh; }
        .sidebar a { color: #ecf0f1; padding: 15px 20px; display: block; text-decoration: none; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-2 sidebar p-0">
            <div class="p-3 text-white text-center">
                <h5><i class="bi bi-gear-fill"></i> لوحة التحكم</h5>
            </div>
            <hr class="bg-light">
            <a href="index.php"><i class="bi bi-speedometer2"></i> الرئيسية</a>
            <a href="users.php"><i class="bi bi-people"></i> المستخدمين</a>
            <a href="tasks.php"><i class="bi bi-list-task"></i> المهام</a>
            <a href="attendance.php"><i class="bi bi-clock-history"></i> الحضور</a>
            <a href="notifications.php" class="active"><i class="bi bi-bell"></i> الإشعارات</a>
            <hr class="bg-light">
            <a href="logout.php"><i class="bi bi-box-arrow-right"></i> خروج</a>
        </div>

        <div class="col-md-10 p-4">
            <h4 class="mb-4">إدارة الإشعارات</h4>

            <?php if ($success): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?= $success ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <?php if ($error): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <?= $error ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>

            <div class="row">
                <!-- Send Notification Form -->
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            <i class="bi bi-send"></i> إرسال إشعار جديد
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label class="form-label">إرسال إلى</label>
                                    <select name="recipient" class="form-select" required>
                                        <option value="all">🌍 الجميع</option>
                                        <option value="staff">👤 الموظفين فقط</option>
                                        <option value="managers">👔 المدراء فقط</option>
                                        <optgroup label="مستخدم محدد">
                                            <?php foreach ($users as $u): ?>
                                            <option value="user_<?= $u['id'] ?>">
                                                <?= htmlspecialchars($u['name']) ?> (<?= $u['role'] ?>)
                                            </option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">عنوان الإشعار</label>
                                    <input type="text" name="title" class="form-control" placeholder="أدخل العنوان" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">نص الإشعار</label>
                                    <textarea name="body" class="form-control" rows="4" placeholder="أدخل نص الرسالة" required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-send"></i> إرسال الإشعار
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Recent Notifications -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header bg-secondary text-white">
                            <i class="bi bi-clock-history"></i> آخر الإشعارات المرسلة
                        </div>
                        <div class="card-body p-0" style="max-height: 500px; overflow-y: auto;">
                            <table class="table table-hover mb-0">
                                <thead class="table-light sticky-top">
                                    <tr>
                                        <th>المستخدم</th>
                                        <th>العنوان</th>
                                        <th>الحالة</th>
                                        <th>التاريخ</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recentNotifications as $n): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($n['user_name']) ?></td>
                                        <td>
                                            <strong><?= htmlspecialchars($n['title']) ?></strong>
                                            <br><small class="text-muted"><?= htmlspecialchars(mb_substr($n['body'], 0, 50)) ?></small>
                                        </td>
                                        <td>
                                            <?php if ($n['is_read']): ?>
                                            <span class="badge bg-success">مقروء</span>
                                            <?php else: ?>
                                            <span class="badge bg-warning">غير مقروء</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><small><?= date('Y-m-d H:i', strtotime($n['created_at'])) ?></small></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
