<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';
require_once '../api/services/NotificationService.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$recipient = $_POST['recipient'] ?? '';
$title = $_POST['title'] ?? '';
$body = $_POST['body'] ?? '';

if (empty($title) || empty($body)) {
    $_SESSION['error'] = 'يرجى ملء جميع الحقول';
    header('Location: index.php');
    exit;
}

$db = Database::getInstance();
$sentCount = 0;

if ($recipient === 'all') {
    $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active'");
    foreach ($users as $user) {
        NotificationService::send($user['id'], $title, $body, 'admin_message');
        $sentCount++;
    }
} elseif ($recipient === 'staff') {
    $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active' AND role = 'staff'");
    foreach ($users as $user) {
        NotificationService::send($user['id'], $title, $body, 'admin_message');
        $sentCount++;
    }
} elseif ($recipient === 'managers') {
    $users = $db->fetchAll("SELECT id FROM users WHERE status = 'active' AND role IN ('admin', 'manager')");
    foreach ($users as $user) {
        NotificationService::send($user['id'], $title, $body, 'admin_message');
        $sentCount++;
    }
} elseif (strpos($recipient, 'user_') === 0) {
    $userId = (int) str_replace('user_', '', $recipient);
    NotificationService::send($userId, $title, $body, 'admin_message');
    $sentCount = 1;
}

$_SESSION['success'] = "تم إرسال الإشعار إلى {$sentCount} مستخدم";
header('Location: index.php');
exit;
