<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$db = Database::getInstance();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $taskId = (int) ($_POST['task_id'] ?? 0);

    if ($action === 'update_status' && $taskId) {
        $db->update('tasks', ['status' => $_POST['status']], 'id = ?', [$taskId]);
    } elseif ($action === 'delete' && $taskId) {
        $db->delete('tasks', 'id = ?', [$taskId]);
    }
    header('Location: tasks.php');
    exit;
}

// Get filters
$status = $_GET['status'] ?? '';
$type = $_GET['type'] ?? '';

$where = ['1=1'];
$params = [];
if ($status) {
    $where[] = 'status = ?';
    $params[] = $status;
}
if ($type) {
    $where[] = 'type = ?';
    $params[] = $type;
}

$tasks = $db->fetchAll(
    "SELECT t.*, u.name as creator_name FROM tasks t 
     LEFT JOIN users u ON t.created_by = u.id 
     WHERE " . implode(' AND ', $where) . " 
     ORDER BY t.created_at DESC",
    $params
);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المهام - IT Task Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .sidebar { background: #2c3e50; min-height: 100vh; }
        .sidebar a { color: #ecf0f1; padding: 15px 20px; display: block; text-decoration: none; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-2 sidebar p-0">
            <div class="p-3 text-white text-center">
                <h5><i class="bi bi-gear-fill"></i> لوحة التحكم</h5>
            </div>
            <hr class="bg-light">
            <a href="index.php"><i class="bi bi-speedometer2"></i> الرئيسية</a>
            <a href="users.php"><i class="bi bi-people"></i> المستخدمين</a>
            <a href="tasks.php" class="active"><i class="bi bi-list-task"></i> المهام</a>
            <a href="attendance.php"><i class="bi bi-clock-history"></i> الحضور</a>
            <a href="notifications.php"><i class="bi bi-bell"></i> الإشعارات</a>
            <hr class="bg-light">
            <a href="logout.php"><i class="bi bi-box-arrow-right"></i> خروج</a>
        </div>

        <div class="col-md-10 p-4">
            <h4 class="mb-4">إدارة المهام</h4>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" class="row g-3">
                        <div class="col-md-3">
                            <select name="status" class="form-select">
                                <option value="">كل الحالات</option>
                                <option value="new" <?= $status === 'new' ? 'selected' : '' ?>>جديد</option>
                                <option value="started" <?= $status === 'started' ? 'selected' : '' ?>>قيد التنفيذ</option>
                                <option value="on_hold" <?= $status === 'on_hold' ? 'selected' : '' ?>>معلق</option>
                                <option value="completed" <?= $status === 'completed' ? 'selected' : '' ?>>مكتمل</option>
                                <option value="cancelled" <?= $status === 'cancelled' ? 'selected' : '' ?>>ملغي</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select name="type" class="form-select">
                                <option value="">كل الأنواع</option>
                                <option value="support" <?= $type === 'support' ? 'selected' : '' ?>>دعم فني</option>
                                <option value="maintenance" <?= $type === 'maintenance' ? 'selected' : '' ?>>صيانة</option>
                                <option value="visit" <?= $type === 'visit' ? 'selected' : '' ?>>زيارة</option>
                                <option value="internal" <?= $type === 'internal' ? 'selected' : '' ?>>داخلي</option>
                                <option value="urgent" <?= $type === 'urgent' ? 'selected' : '' ?>>عاجل</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary">فلترة</button>
                            <a href="tasks.php" class="btn btn-outline-secondary">إعادة</a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>رقم المهمة</th>
                                <th>العنوان</th>
                                <th>النوع</th>
                                <th>الأولوية</th>
                                <th>الحالة</th>
                                <th>المنشئ</th>
                                <th>التاريخ</th>
                                <th>إجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($tasks as $task): ?>
                            <tr>
                                <td><code><?= $task['task_id'] ?></code></td>
                                <td><?= htmlspecialchars(mb_substr($task['title'], 0, 40)) ?></td>
                                <td><span class="badge bg-info"><?= $task['type'] ?></span></td>
                                <td>
                                    <?php
                                    $priorityClass = match($task['priority']) {
                                        'urgent' => 'bg-danger',
                                        'high' => 'bg-warning',
                                        'medium' => 'bg-info',
                                        'low' => 'bg-secondary',
                                        default => 'bg-secondary'
                                    };
                                    ?>
                                    <span class="badge <?= $priorityClass ?>"><?= $task['priority'] ?></span>
                                </td>
                                <td>
                                    <form method="POST" class="d-inline">
                                        <input type="hidden" name="action" value="update_status">
                                        <input type="hidden" name="task_id" value="<?= $task['id'] ?>">
                                        <select name="status" class="form-select form-select-sm" onchange="this.form.submit()" style="width:120px">
                                            <option value="new" <?= $task['status'] === 'new' ? 'selected' : '' ?>>جديد</option>
                                            <option value="started" <?= $task['status'] === 'started' ? 'selected' : '' ?>>قيد التنفيذ</option>
                                            <option value="on_hold" <?= $task['status'] === 'on_hold' ? 'selected' : '' ?>>معلق</option>
                                            <option value="completed" <?= $task['status'] === 'completed' ? 'selected' : '' ?>>مكتمل</option>
                                            <option value="cancelled" <?= $task['status'] === 'cancelled' ? 'selected' : '' ?>>ملغي</option>
                                        </select>
                                    </form>
                                </td>
                                <td><?= htmlspecialchars($task['creator_name'] ?? '-') ?></td>
                                <td><small><?= date('Y-m-d H:i', strtotime($task['created_at'])) ?></small></td>
                                <td>
                                    <form method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="task_id" value="<?= $task['id'] ?>">
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
