<?php
session_start();
require_once '../api/config/config.php';
require_once '../api/config/database.php';

if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$db = Database::getInstance();
$user = $_SESSION['admin_user'];

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $userId = (int) ($_POST['user_id'] ?? 0);

    if ($action === 'toggle_status' && $userId) {
        $currentUser = $db->fetchOne("SELECT status FROM users WHERE id = ?", [$userId]);
        $newStatus = $currentUser['status'] === 'active' ? 'inactive' : 'active';
        $db->update('users', ['status' => $newStatus], 'id = ?', [$userId]);
    } elseif ($action === 'delete' && $userId) {
        $db->delete('users', 'id = ?', [$userId]);
    } elseif ($action === 'create') {
        $db->insert('users', [
            'employee_id' => $_POST['employee_id'],
            'name' => $_POST['name'],
            'email' => $_POST['email'],
            'password' => password_hash($_POST['password'], PASSWORD_DEFAULT),
            'phone' => $_POST['phone'] ?? null,
            'role' => $_POST['role'],
            'department' => $_POST['department'] ?? null,
            'status' => 'active'
        ]);
    }
    header('Location: users.php');
    exit;
}

$users = $db->fetchAll("SELECT * FROM users ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المستخدمين - IT Task Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body { background: #f5f6fa; }
        .sidebar { background: #2c3e50; min-height: 100vh; }
        .sidebar a { color: #ecf0f1; padding: 15px 20px; display: block; text-decoration: none; }
        .sidebar a:hover, .sidebar a.active { background: #34495e; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-2 sidebar p-0">
            <div class="p-3 text-white text-center">
                <h5><i class="bi bi-gear-fill"></i> لوحة التحكم</h5>
            </div>
            <hr class="bg-light">
            <a href="index.php"><i class="bi bi-speedometer2"></i> الرئيسية</a>
            <a href="users.php" class="active"><i class="bi bi-people"></i> المستخدمين</a>
            <a href="tasks.php"><i class="bi bi-list-task"></i> المهام</a>
            <a href="attendance.php"><i class="bi bi-clock-history"></i> الحضور</a>
            <a href="notifications.php"><i class="bi bi-bell"></i> الإشعارات</a>
            <hr class="bg-light">
            <a href="logout.php"><i class="bi bi-box-arrow-right"></i> خروج</a>
        </div>

        <div class="col-md-10 p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4>إدارة المستخدمين</h4>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
                    <i class="bi bi-plus"></i> إضافة مستخدم
                </button>
            </div>

            <div class="card">
                <div class="card-body p-0">
                    <table class="table table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>رقم الموظف</th>
                                <th>الاسم</th>
                                <th>البريد</th>
                                <th>الدور</th>
                                <th>الحالة</th>
                                <th>إجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $u): ?>
                            <tr>
                                <td><?= htmlspecialchars($u['employee_id']) ?></td>
                                <td><?= htmlspecialchars($u['name']) ?></td>
                                <td><?= htmlspecialchars($u['email']) ?></td>
                                <td>
                                    <span class="badge bg-<?= $u['role'] === 'admin' ? 'danger' : ($u['role'] === 'manager' ? 'warning' : 'info') ?>">
                                        <?= $u['role'] ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?= $u['status'] === 'active' ? 'success' : 'secondary' ?>">
                                        <?= $u['status'] === 'active' ? 'نشط' : 'غير نشط' ?>
                                    </span>
                                </td>
                                <td>
                                    <form method="POST" class="d-inline">
                                        <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                                        <input type="hidden" name="action" value="toggle_status">
                                        <button type="submit" class="btn btn-sm btn-outline-warning">
                                            <i class="bi bi-toggle-on"></i>
                                        </button>
                                    </form>
                                    <form method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد؟')">
                                        <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                                        <input type="hidden" name="action" value="delete">
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add User Modal -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <input type="hidden" name="action" value="create">
                <div class="modal-header">
                    <h5 class="modal-title">إضافة مستخدم جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">رقم الموظف</label>
                        <input type="text" name="employee_id" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الهاتف</label>
                        <input type="text" name="phone" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الدور</label>
                        <select name="role" class="form-select" required>
                            <option value="staff">موظف</option>
                            <option value="manager">مدير</option>
                            <option value="admin">مسؤول</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">القسم</label>
                        <input type="text" name="department" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
