# IT Task Management System - Backend API

## Setup Instructions

### 1. Database Setup
1. Start XAMPP and ensure MySQL is running
2. Open phpMyAdmin or MySQL CLI
3. Import the database schema:
   ```sql
   source c:/xampp/htdocs/ittask/api/database/schema.sql
   ```

### 2. Configuration
Edit `config/config.php` to update:
- Database credentials (if different from default)
- JWT secret key (change for production!)
- Firebase server key (for push notifications)
- API base URL

### 3. Directory Permissions
Ensure these directories are writable:
- `uploads/`
- `cache/`

### 4. Default Admin Login
- Email: `admin@ittasks.local`
- Password: `admin123`

## API Endpoints

### Authentication
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/auth/login` | User login |
| POST | `/auth/logout` | User logout |
| POST | `/auth/refresh` | Refresh token |
| GET | `/auth/me` | Get current user |
| POST | `/auth/change-password` | Change password |
| POST | `/auth/device-token` | Register device token |

### Users
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/users` | List users (Manager+) |
| GET | `/users/{id}` | Get user details |
| GET | `/users/staff` | Get staff list |
| POST | `/users` | Create user (Admin) |
| PUT | `/users/{id}` | Update user |
| DELETE | `/users/{id}` | Delete user (Admin) |
| PUT | `/users/status` | Update live status |

### Tasks
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/tasks` | List all tasks |
| GET | `/tasks/my` | Get my tasks |
| GET | `/tasks/{id}` | Get task details |
| POST | `/tasks` | Create task |
| PUT | `/tasks/{id}` | Update task |
| DELETE | `/tasks/{id}` | Delete task (Manager+) |
| POST | `/tasks/{id}/start` | Start task |
| POST | `/tasks/{id}/complete` | Complete task |
| POST | `/tasks/{id}/hold` | Put task on hold |
| POST | `/tasks/{id}/resume` | Resume task |
| POST | `/tasks/{id}/assign` | Assign task (Manager+) |
| GET | `/tasks/{id}/logs` | Get task logs |
| GET | `/tasks/{id}/attachments` | Get task attachments |
| POST | `/tasks/{id}/voice-note` | Add voice note |

### Attendance
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/attendance/check-in` | Check in |
| POST | `/attendance/check-out` | Check out |
| POST | `/attendance/break` | Start break |
| POST | `/attendance/end-break` | End break |
| GET | `/attendance/today` | Get today's attendance |
| GET | `/attendance/my` | Get my attendance history |
| GET | `/attendance` | List attendance (Manager+) |

### Notifications
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/notifications` | Get notifications |
| GET | `/notifications/unread-count` | Get unread count |
| PUT | `/notifications/{id}` | Mark as read |
| POST | `/notifications/read-all` | Mark all as read |
| DELETE | `/notifications/{id}` | Delete notification |

### Dashboard
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/dashboard` | Get dashboard data |
| GET | `/dashboard/stats` | Get statistics (Manager+) |
| GET | `/dashboard/my-stats` | Get my statistics |
| GET | `/dashboard/team-status` | Get team status (Manager+) |

### Recurring Tasks
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/recurring-tasks` | List recurring tasks |
| POST | `/recurring-tasks` | Create recurring task |
| PUT | `/recurring-tasks/{id}` | Update recurring task |
| DELETE | `/recurring-tasks/{id}` | Delete recurring task |
| POST | `/recurring-tasks/run` | Run recurring tasks manually |

### Templates
| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/templates` | List templates |
| POST | `/templates` | Create template (Manager+) |
| PUT | `/templates/{id}` | Update template |
| DELETE | `/templates/{id}` | Delete template |

### File Upload
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/upload/task-attachment` | Upload task attachment |
| POST | `/upload/voice-note` | Upload voice note |
| POST | `/upload/avatar` | Upload avatar |
| POST | `/upload/evidence` | Upload evidence photo |

## Cron Jobs
Add to crontab for recurring tasks:
```bash
0 0 * * * php /path/to/api/cron/recurring_tasks.php
```

## Security Notes
- Change JWT_SECRET in production
- Use HTTPS in production
- Update CORS settings for production
- Enable rate limiting
